/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.fedc;

import com.ibm.hwmca.base.pa.fedc.ConsoleFEDCKey;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.pa.fedc.FEDCCollectionAgent;
import com.ibm.hwmca.fw.pa.fedc.FEDCKey;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkThread;
import com.ibm.hwmca.xfw.pa.fedc.FEDCExecutable;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import com.ibm.hwmca.xfw.pa.fedc.FEDCGoodie;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.CommonPaUtils;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConsoleFEDCCollectionAgent
implements FEDCCollectionAgent {
    private static final String TRACE_MASKT = "XPAFEDCT";
    private static final String TRACE_MASKF = "XPAFEDCF";
    private static final String TRACE_MASKD = "XPAFEDCD";
    private static final String DEFAULT_FEDC_PATH = "fedcdirectory";
    private static final String DEFAULT_FILE_NAME = "default.xml";
    private static final String FILTER_FILE_NAME = "iqypfilt.xml";
    private static final String FILE_NAME_PREFIX = "iqypfl";
    private static final String FILE_NAME_SUFFIX = ".xml";
    private static final String PRE_EXECUTE_NODES = "pre";
    private static final String POST_EXECUTE_NODES = "post";
    private static final String CLEANUP_EXECUTE_NODES = "cleanup";
    private static final String FILE_NODE_ID = "file";
    private static final String EXE_NODE_ID = "execute";
    private static final String GOODIE_NODE_ID = "goodie";
    private static final String DIR_NODE_ID = "dir";
    private static final long WAIT_TIME = 60000L;
    private ArrayList _threadArray = new ArrayList();
    private Map _topMap = new HashMap(2);
    private Map _filtMap = new HashMap(2);
    private Map _keyMap = new HashMap(2);

    public ConsoleFEDCCollectionAgent() throws HException {
        Trace.trace(TRACE_MASKD, "--> ConsoleFEDCCollectionAgent");
        try {
            String filePath = BaseFileControl.getFilePath(DEFAULT_FEDC_PATH);
            FileInputStream fis = new FileInputStream(filePath + DEFAULT_FILE_NAME);
            Document defaultDoc = new HwmcaParser(fis, false).getDocument();
            Trace.trace(TRACE_MASKD, "done parsing default");
            Element root = defaultDoc.getDocumentElement();
            this.processNode(root, this._topMap);
            filePath = BaseFileControl.getFilePath(DEFAULT_FEDC_PATH);
            fis = new FileInputStream(filePath + FILTER_FILE_NAME);
            if (fis != null) {
                Document filterDoc = new HwmcaParser(fis, false).getDocument();
                Trace.trace(TRACE_MASKD, "done parsing filter document");
                root = filterDoc.getDocumentElement();
                this.processNode(root, this._filtMap);
            } else {
                Trace.trace(TRACE_MASKF, "didn't load iqypfilt since it doesn't exist");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "didn't load iqypfilt since it doesn't exist");
        }
        Trace.trace(TRACE_MASKD, "<-- ConsoleFEDCCollectionAgent");
    }

    public List getResolvedFileList(FEDCKey key) throws HException {
        Trace.trace(TRACE_MASKT, "--> getResolvedFileList(key)");
        ArrayList mapList = new ArrayList();
        ArrayList resolvedFilterList = new ArrayList();
        ArrayList keyResolvedFilterList = new ArrayList();
        if (key != null) {
            this.buildTypeMap(key);
            if (this._keyMap != null) {
                this.walkMap(FILE_NODE_ID, this._keyMap, keyResolvedFilterList, key);
            }
        }
        Trace.trace(TRACE_MASKD, "got " + keyResolvedFilterList.size() + "file from the key section");
        this.walkMap(FILE_NODE_ID, this._topMap, mapList, key);
        Trace.trace(TRACE_MASKD, "got " + mapList.size() + "file from the default section");
        ArrayList filterList = new ArrayList();
        this.walkMap(FILE_NODE_ID, this._filtMap, filterList, key);
        Trace.trace(TRACE_MASKD, "got " + filterList.size() + "file from the default section");
        filterList.addAll(mapList);
        filterList.addAll(keyResolvedFilterList);
        CommonPaUtils.resolveFileList(filterList, resolvedFilterList);
        Trace.trace(TRACE_MASKT, "<-- getResolvedFileList(key)");
        return resolvedFilterList;
    }

    public List getResolvedFileList(Problem problem) throws HException {
        Trace.trace(TRACE_MASKT, "--> getResolvedFileList()");
        FEDCKey key = null;
        if (problem instanceof CommonProblem) {
            key = ((CommonProblem)problem).getFEDCKey();
        } else {
            Trace.trace(TRACE_MASKF, "Don't have a common problem to work with. Nothing to return.");
        }
        Trace.trace(TRACE_MASKT, "<-- getResolvedFileList()");
        return this.getResolvedFileList(key);
    }

    public List getFileList(Problem problem) throws HException {
        Trace.trace(TRACE_MASKT, "--> getFileList()");
        ArrayList filterOutList = new ArrayList();
        ArrayList outList = new ArrayList();
        ArrayList keyOutList = new ArrayList();
        FEDCKey key = null;
        if (problem instanceof CommonProblem) {
            key = ((CommonProblem)problem).getFEDCKey();
            if (key != null) {
                this.buildTypeMap(key);
            }
        } else {
            Trace.trace(TRACE_MASKF, "Don't have a common problem to work with. Nothing to return.");
        }
        this.walkMap(FILE_NODE_ID, this._topMap, outList, key);
        this.walkMap(FILE_NODE_ID, this._filtMap, filterOutList, key);
        if (this._keyMap != null) {
            this.walkMap(FILE_NODE_ID, this._keyMap, keyOutList, key);
            outList.addAll(keyOutList);
        }
        outList.addAll(filterOutList);
        Trace.trace(TRACE_MASKT, "<-- getFileList()");
        return outList;
    }

    public synchronized void executeModules(Problem problem) throws HException {
        Trace.trace(TRACE_MASKF, "--> executeModules");
        this.executeModules(PRE_EXECUTE_NODES, problem);
        Trace.trace(TRACE_MASKF, "<-- executeModules");
    }

    public synchronized void postAnalysisExecuteModules(Problem problem) throws HException {
        Trace.trace(TRACE_MASKF, "--> postAnalysisExecuteModules");
        if (problem instanceof CommonProblem) {
            this.executeModules(POST_EXECUTE_NODES, problem);
        } else {
            Trace.trace(TRACE_MASKF, "Don't have a common problem to work with. Nothing to return.");
        }
        Trace.trace(TRACE_MASKF, "<-- postAnalysisExecuteModules");
    }

    public synchronized void cleanUpAnalysisExecuteModules(Problem problem) throws HException {
        Trace.trace(TRACE_MASKF, "--> cleanUpAnalysisExecuteModules");
        if (problem instanceof CommonProblem) {
            this.executeModules(CLEANUP_EXECUTE_NODES, problem);
        } else {
            Trace.trace(TRACE_MASKF, "Don't have a common problem to work with. Nothing to return.");
        }
        Trace.trace(TRACE_MASKF, "<-- cleanUpAnalysisExecuteModules");
    }

    private synchronized void executeModules(String type, Problem problem) throws HException {
        Trace.trace(TRACE_MASKT, "-->executeModules(type=" + type + ")");
        ArrayList fullExecuteList = new ArrayList();
        ArrayList keyExecuteList = new ArrayList();
        ArrayList fullFilterExecuteList = new ArrayList();
        ArrayList<FEDCExecutable> filteredDefaultExeList = new ArrayList<FEDCExecutable>();
        ArrayList filteredExeList = new ArrayList();
        if (problem instanceof CommonProblem) {
            FEDCKey key = ((CommonProblem)problem).getFEDCKey();
            if (key != null) {
                this.buildTypeMap(key);
                if (this._keyMap != null) {
                    Trace.trace(TRACE_MASKD, "walk the keyed map for the executables");
                    this.walkMap(EXE_NODE_ID, this._keyMap, keyExecuteList, key);
                }
            }
            this.walkMap(EXE_NODE_ID, this._topMap, fullExecuteList, key);
            Trace.trace(TRACE_MASKD, "the full exec list length =" + fullExecuteList.size());
            this.walkMap(EXE_NODE_ID, this._filtMap, fullFilterExecuteList, key);
            Trace.trace(TRACE_MASKD, "the full filterd exec list length =" + fullFilterExecuteList.size());
            fullExecuteList.addAll(keyExecuteList);
            fullExecuteList.addAll(fullFilterExecuteList);
            int threadCount = fullExecuteList.size();
            Trace.trace(TRACE_MASKD, "got threadCount of " + threadCount);
            int i = 0;
            while (i < threadCount) {
                Trace.trace(TRACE_MASKD, "got executable of ->" + (FEDCExecutable)fullExecuteList.get(i));
                FEDCExecutable item = (FEDCExecutable)fullExecuteList.get(i);
                if (item._executeType.toLowerCase().trim().equals(type)) {
                    filteredDefaultExeList.add(item);
                }
                ++i;
            }
            threadCount = filteredDefaultExeList.size();
            Trace.trace(TRACE_MASKD, "got filterThreadCount of " + threadCount);
            Runnable[] fedcThreads = new Runnable[threadCount];
            int i2 = 0;
            while (i2 < threadCount) {
                Object element = filteredDefaultExeList.get(i2);
                ((FEDCExecutable)element)._problem = problem;
                fedcThreads[i2] = (Runnable)element;
                ++i2;
            }
            int i3 = 0;
            while (i3 < threadCount) {
                Object element = filteredDefaultExeList.get(i3);
                ((FEDCExecutable)element)._problem = problem;
                this._threadArray.add(element);
                ++i3;
            }
            if (threadCount > 0) {
                try {
                    Trace.trace(TRACE_MASKF, "starting the collection threads");
                    Throwable[] returns = null;
                    returns = WorkThread.runSynchronously(fedcThreads, true, 3600000L);
                    Trace.trace(TRACE_MASKF, "back from the runs");
                    Trace.trace(TRACE_MASKF, "RunSynchronously() clean end, checking status.");
                    int i4 = 0;
                    while (i4 < returns.length) {
                        Trace.trace(TRACE_MASKF, "thread " + i4);
                        if (returns[i4] == null) {
                            Trace.trace(TRACE_MASKF, "clean end");
                        } else {
                            Trace.trace(TRACE_MASKF, "exception end");
                            Trace.trace(TRACE_MASKF, returns[i4]);
                        }
                        ++i4;
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "runSynchronously() tossed an exception.");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "nothing to run");
            }
        } else {
            Trace.trace(TRACE_MASKF, "Don't have a common problem to work with. Nothing to return.");
        }
        Trace.trace(TRACE_MASKT, "<--executeModules()");
    }

    public List getGoodies(Problem problem) throws HException {
        Trace.trace(TRACE_MASKT, "--> getGoodies()");
        ArrayList outList = new ArrayList();
        ArrayList outFilterList = new ArrayList();
        ArrayList keyFilterList = new ArrayList();
        FEDCKey key = null;
        if (problem instanceof CommonProblem && (key = ((CommonProblem)problem).getFEDCKey()) != null) {
            this.buildTypeMap(key);
            if (this._keyMap != null) {
                this.walkMap(GOODIE_NODE_ID, this._keyMap, keyFilterList, key);
                outList.addAll(keyFilterList);
            }
        }
        Trace.trace(TRACE_MASKD, "walk the default map");
        this.walkMap(GOODIE_NODE_ID, this._topMap, outList, key);
        Trace.trace(TRACE_MASKD, "walk the filter map");
        this.walkMap(GOODIE_NODE_ID, this._filtMap, outFilterList, key);
        outList.addAll(outFilterList);
        Trace.trace(TRACE_MASKT, "<-- getGoodies()");
        return outList;
    }

    public List getResolvedDefaultFileList() throws HException {
        Trace.trace(TRACE_MASKD, "--> getResolvedDefaultFileList");
        ArrayList mapList = new ArrayList();
        ArrayList resolvedList = new ArrayList();
        this.walkMap(FILE_NODE_ID, this._topMap, mapList, null);
        CommonPaUtils.resolveFileList(mapList, resolvedList);
        Trace.trace(TRACE_MASKD, "<-- getResolvedDefaultFileList");
        return resolvedList;
    }

    public List getDefaultFileList() throws HException {
        Trace.trace(TRACE_MASKD, "--> getDefaultFileList");
        ArrayList mapList = new ArrayList();
        this.walkMap(FILE_NODE_ID, this._topMap, mapList, null);
        Trace.trace(TRACE_MASKD, "<-- getDefaultFileList");
        return mapList;
    }

    private void walkMap(String nodeType, Map map, List outputList, FEDCKey key) {
        Trace.trace(TRACE_MASKD, "--> walkMap");
        Trace.trace(TRACE_MASKD, "nodeType =" + nodeType);
        Set keySet = map.keySet();
        Iterator it = keySet.iterator();
        String searchKey = "";
        List tempList = new ArrayList();
        while (it.hasNext()) {
            String item = (String)it.next();
            if (item.toLowerCase().trim().equals("default")) {
                Trace.trace(TRACE_MASKD, "working on the default section ");
                Map endMap = (Map)map.get(item);
                tempList = this.gatherList(endMap, nodeType);
                if (tempList != null) {
                    Trace.trace(TRACE_MASKD, "templist length is " + tempList.size());
                    outputList.addAll(tempList);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "nothing in the default section.");
                continue;
            }
            if (key != null) {
                Trace.trace(TRACE_MASKD, "working on the non-default part");
                if (item.toLowerCase().trim().equals("refcode")) {
                    searchKey = ((ConsoleFEDCKey)key).getRefcode();
                } else if (item.toLowerCase().trim().equals("type")) {
                    searchKey = ((ConsoleFEDCKey)key).getLogClass();
                } else if (item.toLowerCase().trim().equals("extension")) {
                    searchKey = ((ConsoleFEDCKey)key).getExtension();
                }
                Trace.trace(TRACE_MASKD, "get the nested map for " + searchKey);
                this.nestedMap((Map)map.get(item), key, searchKey, nodeType, outputList);
                continue;
            }
            Trace.trace(TRACE_MASKD, "only get the default list");
        }
        Trace.trace(TRACE_MASKD, "<-- walkMap");
    }

    private void processNode(Node node, Map map) {
        NodeList childNodes = node.getChildNodes();
        String nodeName = "Nothing";
        int numChildren = childNodes.getLength();
        Trace.trace(TRACE_MASKD, "got " + numChildren + " children to process");
        int i = 0;
        while (i < numChildren) {
            Trace.trace(TRACE_MASKD, "i=" + i);
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().toLowerCase().trim().equals("default")) {
                    Trace.trace(TRACE_MASKD, "got the default node");
                    this.processDefaultNode(child, map);
                } else {
                    nodeName = child.getNodeName();
                    Trace.trace(TRACE_MASKD, "node name = " + nodeName);
                    Trace.trace(TRACE_MASKD, "adding new table for " + nodeName);
                    if (this.isLeafNode(child)) {
                        if (!map.containsKey(nodeName)) {
                            map.put(nodeName, new ArrayList());
                        }
                        this.processLeafNode(child, map);
                    } else {
                        Map nextMap;
                        if (!map.containsKey(nodeName)) {
                            nextMap = new HashMap();
                            Trace.trace(TRACE_MASKD, "putting a map for " + nodeName);
                            map.put(nodeName, nextMap);
                        } else {
                            nextMap = (Map)map.get(nodeName);
                        }
                        Node valueNode = child.getAttributes().getNamedItem("value");
                        String value = "other";
                        if (valueNode != null) {
                            value = valueNode.getNodeValue().trim();
                        }
                        Trace.trace(TRACE_MASKD, "value = " + value);
                        HashMap thirdMap = new HashMap();
                        nextMap.put(value, thirdMap);
                        this.processNode(child, thirdMap);
                    }
                }
            } else {
                Trace.trace(TRACE_MASKD, "got a non-element node" + child.getNodeName());
            }
            ++i;
        }
    }

    private boolean isLeafNode(Node node) {
        String nodeName = node.getNodeName().toLowerCase().trim();
        return nodeName.equals(FILE_NODE_ID) || nodeName.equals(EXE_NODE_ID) || nodeName.equals("exe") || nodeName.equals(GOODIE_NODE_ID) || nodeName.equals("dll") || nodeName.equals("java");
    }

    private void processDefaultNode(Node node, Map map) {
        Trace.trace(TRACE_MASKF, "-->processDefaultNode");
        HashMap defaultMap = new HashMap();
        map.put("default", defaultMap);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Trace.trace(TRACE_MASKD, "processing default child node" + i);
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (!defaultMap.containsKey(nodeName)) {
                    Trace.trace(TRACE_MASKD, "create new array list for " + nodeName);
                    defaultMap.put(nodeName, new ArrayList());
                }
                this.processLeafNode(child, defaultMap);
            }
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<--processDefaultNode");
    }

    private void processLeafNode(Node node, Map map) {
        Trace.trace(TRACE_MASKF, "-->processLeafNode");
        if (node.getNodeName().toLowerCase().trim().equals(FILE_NODE_ID)) {
            String dir;
            String wait;
            FEDCFileDescriptor fileDesc = new FEDCFileDescriptor();
            fileDesc.type = node.getAttributes().getNamedItem("type").getNodeValue().trim();
            fileDesc.priority = node.getAttributes().getNamedItem("priority").getNodeValue().trim();
            fileDesc.name = node.getAttributes().getNamedItem("name").getNodeValue().trim();
            Node waitNode = node.getAttributes().getNamedItem("wait");
            fileDesc.wait = waitNode != null ? (wait = node.getAttributes().getNamedItem("wait").getNodeValue().trim()).equals("true") : false;
            Node dirNode = node.getAttributes().getNamedItem(DIR_NODE_ID);
            if (dirNode != null && (dir = node.getAttributes().getNamedItem(DIR_NODE_ID).getNodeValue().trim()) != null) {
                fileDesc.directory = dir;
            }
            List list = (List)map.get(FILE_NODE_ID);
            Trace.trace(TRACE_MASKD, "adding filedescriptor" + fileDesc);
            list.add(fileDesc);
        } else if (node.getNodeName().toLowerCase().trim().equals(EXE_NODE_ID)) {
            FEDCExecutable execD = new FEDCExecutable(node);
            List list = (List)map.get(EXE_NODE_ID);
            Trace.trace(TRACE_MASKD, "adding executable " + execD);
            list.add(execD);
        } else if (node.getNodeName().toLowerCase().trim().equals(GOODIE_NODE_ID)) {
            FEDCGoodie goodie = new FEDCGoodie();
            goodie.name = node.getAttributes().getNamedItem("name").getNodeValue().trim();
            try {
                goodie.value = CommonXMLParser.gatherTextContents(node);
                List list = (List)map.get(GOODIE_NODE_ID);
                Trace.trace(TRACE_MASKD, "adding goodie" + goodie);
                list.add(goodie);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "this is an informational exception");
                Trace.trace(TRACE_MASKD, e);
            }
        }
        Trace.trace(TRACE_MASKF, "<--processLeafNode");
    }

    private void nestedMap(Map map, FEDCKey fedcKey, String searchValue, String type, List outputList) {
        Trace.trace(TRACE_MASKD, "-->nestedMap");
        Map matchMap = null;
        Set keySet = map.keySet();
        Trace.trace(TRACE_MASKD, "got " + keySet.size() + " key on this map");
        Iterator it = keySet.iterator();
        while (it.hasNext() && matchMap == null) {
            String item = (String)it.next();
            Trace.trace(TRACE_MASKD, "make the patterns upper case.");
            item = item.toUpperCase();
            searchValue = searchValue.toUpperCase();
            Trace.trace(TRACE_MASKD, "working on item -> " + item);
            if (matchMap == null && item.toLowerCase().trim().equals("other")) {
                Trace.trace(TRACE_MASKD, "hit the other leg");
                matchMap = (Map)map.get(item);
            }
            if (!this.keyMatch(searchValue, item)) continue;
            matchMap = (Map)map.get(item);
        }
        List tempList = null;
        if (matchMap != null) {
            Trace.trace(TRACE_MASKD, "matchMap != null. Get the values on it");
            Set nestedKeySet = matchMap.keySet();
            Trace.trace(TRACE_MASKD, "we have " + nestedKeySet.size() + " key to work with");
            Iterator nestedIt = nestedKeySet.iterator();
            String searchKey = "";
            while (nestedIt.hasNext()) {
                String nestedItem = (String)nestedIt.next();
                Trace.trace(TRACE_MASKD, "nestedItem is " + nestedItem);
                if (nestedItem.toLowerCase().trim().equals("refcode")) {
                    searchKey = ((ConsoleFEDCKey)fedcKey).getRefcode();
                } else if (nestedItem.toLowerCase().trim().equals("type")) {
                    searchKey = ((ConsoleFEDCKey)fedcKey).getLogClass();
                } else if (nestedItem.toLowerCase().trim().equals("extension")) {
                    searchKey = ((ConsoleFEDCKey)fedcKey).getExtension();
                }
                Trace.trace(TRACE_MASKD, "searchKey is " + searchKey);
                if (searchKey.equals("")) continue;
                Trace.trace(TRACE_MASKD, "call nest map");
                this.nestedMap((Map)matchMap.get(nestedItem), fedcKey, searchKey, type, outputList);
                searchKey = "";
            }
            Trace.trace(TRACE_MASKD, "Done with the nested loops");
            Trace.trace(TRACE_MASKD, "Gather up any lists on this node");
            tempList = this.gatherList(matchMap, type);
        }
        if (tempList != null) {
            outputList.addAll(tempList);
        }
        Trace.trace(TRACE_MASKD, "<-- nestedMap");
    }

    private List gatherList(Map map, String key) {
        Trace.trace(TRACE_MASKD, "looking for key = " + key);
        Set keySet = map.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            Trace.trace(TRACE_MASKD, "the value is " + item);
            if (!item.equals(key)) continue;
            Trace.trace(TRACE_MASKD, "found the item to return. key =" + key);
            return (List)map.get(item);
        }
        Trace.trace(TRACE_MASKD, "got nothing to return");
        return null;
    }

    private boolean keyMatch(String searchValue, String pattern) {
        Trace.trace(TRACE_MASKD, "-->keyMatch (" + searchValue + "," + pattern + ")");
        int searchLength = searchValue.length();
        int i = 0;
        while (i < searchLength) {
            if (pattern.charAt(i) != '*' && searchValue.charAt(i) != pattern.charAt(i)) {
                Trace.trace(TRACE_MASKD, "return false");
                Trace.trace(TRACE_MASKD, "<--keyMatch");
                return false;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "return true");
        Trace.trace(TRACE_MASKD, "<--keyMatch");
        return true;
    }

    public static void main(String[] args) {
        ConsoleFEDCKey key = new ConsoleFEDCKey("1B", "22", "22221234", "87654321");
        CommonProblem myProblem = new CommonProblem();
        myProblem.setFEDCKey(key);
        if (args.length != 5) {
            System.out.println("usage is :\n");
            System.out.println("ConsoleFEDCKey cc tt rrrrrrrr eeeeeeee data");
            System.out.println("where");
            System.out.println("cc is the log class");
            System.out.println("tt is the log type");
            System.out.println("rrrrrrrr is the refcode");
            System.out.println("eeeeeeee is the extension");
            System.out.println("data is the type of data to get.\n");
            System.out.println("valid types are:");
            System.out.println("file for the file data");
            System.out.println("rfile for the resolved file data");
            System.out.println("deffile for the default file data");
            System.out.println("defrfile for the resolved default file data");
            System.out.println("goodie for the goodie data");
        } else {
            try {
                if (args.length == 5) {
                    key = new ConsoleFEDCKey(args[0], args[1], args[2], args[3]);
                    myProblem.setFEDCKey(key);
                }
                ConsoleFEDCCollectionAgent agent = new ConsoleFEDCCollectionAgent();
                if (args.length > 3 && args[4].equals("postexe")) {
                    System.out.println("run post execute");
                    Trace.trace(TRACE_MASKD, "run the post execute modules");
                    agent.postAnalysisExecuteModules(myProblem);
                    Trace.trace(TRACE_MASKD, "done");
                    return;
                }
                if (args.length > 3 && args[4].equals(FILE_NODE_ID)) {
                    System.out.println("getting the file info");
                    List fileList = agent.getFileList(myProblem);
                    Trace.trace(TRACE_MASKD, "number of files " + fileList.size());
                    int i = 0;
                    while (i < fileList.size()) {
                        Trace.trace(TRACE_MASKD, fileList.get(i));
                        FEDCFileDescriptor file = (FEDCFileDescriptor)fileList.get(i);
                        System.out.println("file info->" + file);
                        ++i;
                    }
                    return;
                }
                if (args.length > 3 && args[4].equals("deffile")) {
                    System.out.println("getting the default file info");
                    List fileList = agent.getDefaultFileList();
                    Trace.trace(TRACE_MASKD, "number of files " + fileList.size());
                    int i = 0;
                    while (i < fileList.size()) {
                        Trace.trace(TRACE_MASKD, fileList.get(i));
                        FEDCFileDescriptor file = (FEDCFileDescriptor)fileList.get(i);
                        System.out.println("file info->" + file);
                        ++i;
                    }
                    return;
                }
                if (args.length > 3 && args[4].equals("defrfile")) {
                    System.out.println("getting the default resolved file info");
                    List fileList = agent.getResolvedDefaultFileList();
                    Trace.trace(TRACE_MASKD, "number of files " + fileList.size());
                    int i = 0;
                    while (i < fileList.size()) {
                        Trace.trace(TRACE_MASKD, fileList.get(i));
                        FEDCFileDescriptor file = (FEDCFileDescriptor)fileList.get(i);
                        System.out.println("file info->" + file);
                        ++i;
                    }
                    return;
                }
                if (args.length > 3 && args[4].equals("rfile")) {
                    System.out.println("getting the resolved file info");
                    List fileList = agent.getResolvedFileList(myProblem);
                    Trace.trace(TRACE_MASKD, "number of files " + fileList.size());
                    int i = 0;
                    while (i < fileList.size()) {
                        Trace.trace(TRACE_MASKD, fileList.get(i));
                        FEDCFileDescriptor file = (FEDCFileDescriptor)fileList.get(i);
                        System.out.println("file info->" + file);
                        ++i;
                    }
                    return;
                }
                if (args.length > 3 && args[4].equals("goodies")) {
                    System.out.println("getting the goodies info");
                    List goodieList = agent.getGoodies(myProblem);
                    int i = 0;
                    while (i < goodieList.size()) {
                        System.out.println("goodie is ->" + goodieList.get(i));
                        ++i;
                    }
                    return;
                }
                if (args.length > 3 && args[4].equals(CLEANUP_EXECUTE_NODES)) {
                    System.out.println("run the cleanup routines");
                    Trace.trace(TRACE_MASKD, "run the cleanup routines");
                    agent.cleanUpAnalysisExecuteModules(myProblem);
                    Trace.trace(TRACE_MASKD, "done");
                    return;
                }
                System.out.println("Invalid type of data to retrieve specified\n");
                System.out.println("valid types are:");
                System.out.println("file for the file data");
                System.out.println("rfile for the resolved file data");
                System.out.println("deffile for the default file data");
                System.out.println("defrfile for the resolved default file data");
                System.out.println("goodie for the goodie data");
            }
            catch (Exception e) {
                System.out.println("got an exception. This is only for information. This is not a problem!!!");
                System.out.println(e);
            }
        }
    }

    private void buildTypeMap(FEDCKey key) {
        block2: {
            if (key == null || !(key instanceof ConsoleFEDCKey)) break block2;
            try {
                String fileName = FILE_NAME_PREFIX + ((ConsoleFEDCKey)key).getLocation() + FILE_NAME_SUFFIX;
                Trace.trace(TRACE_MASKD, "get file name [" + fileName + "]");
                String filePath = BaseFileControl.getFilePath(DEFAULT_FEDC_PATH);
                FileInputStream fis = new FileInputStream(filePath + fileName);
                Document keyedDoc = new HwmcaParser(fis, false).getDocument();
                Trace.trace(TRACE_MASKD, "done parsing keyed doc");
                Element root = keyedDoc.getDocumentElement();
                this.processNode(root, this._keyMap);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception. This is only for information. This is not a problem!!!");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }
}

